*SECOND GENERATION IMMIGRANTS ANALYSIS EXPLOITUNG WITHIN COUNTRY VARIATION OF THE ORIGN COUNTRY DUE TO MATCHING OF ETHNICITIES
*THIS CREATES APPENDIX TABLE D4


clear all
use data\SecondGen_AncetralEthnicity.dta, replace


*____________________________________________________
*	Table D4: Kin networks of Fathers’ Ancestral Ethnicities & Political activity
preserve

keep if facntr == 2 //non-domestic mother
drop if fbrncnt =="99" //drop those where origin is not known
drop if fbrncnt =="88"
drop if fbrncnt =="77"
drop if fbrncnt =="06"
drop if fbrncnt =="04"
drop if fbrncnt =="03"
drop if fbrncnt =="02"

keep if mbrncnt==fbrncnt | mbrncnt==cntry //keep only those where father is from the same country as mother or mother is native

*drop entries with missing data for covariates so that all specifications have the same number of observations
drop if dscrgrp==. | rlgdgr==. | uempla==. | uempli==. | ageb==. | ageb_sqrt==. | gndr==. | married==. | rlgdnm==.
drop if co_fishing==. | co_husbandry==. | co_agriculture==. | co_hierarchy==. | co_irrigation==. | co_settlementcomplex_mean==.

local x co_fishing co_husbandry co_agriculture co_hierarchy co_irrigation co_settlementcomplex_mean
local y activity1

* Panel 1: Cousin marriage preference
local v fs_cousin_preferred_cont_mean
eststo: xi: areg `y' `v'      i.cntry ageb ageb_sqrt gndr i.essround  , absorb(fbrncnt) cluster(cntry)
eststo: xi: areg `y' `v'  `x' i.cntry ageb ageb_sqrt gndr i.essround  , absorb(fbrncnt) cluster(cntry)
eststo: xi: areg `y' `v'  `x' i.cntry dscrgrp uempla uempli married ageb ageb_sqrt gndr i.essround  , absorb(fbrncnt) cluster(cntry)
eststo: xi: areg `y' `v'  `x' i.cntry dscrgrp uempla uempli married i.rlgdnm rlgdgr ageb ageb_sqrt gndr i.essround , absorb(fbrncnt) cluster(cntry)
esttab using tables/TableD4_Panel_1.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear

* Panel 2: Cousin-term differentiation
local v fs_diff_cousin_mean
eststo: xi: areg `y' `v'      i.cntry ageb ageb_sqrt gndr i.essround  , absorb(fbrncnt) cluster(cntry)
eststo: xi: areg `y' `v'  `x' i.cntry ageb ageb_sqrt gndr i.essround  , absorb(fbrncnt) cluster(cntry)
eststo: xi: areg `y' `v'  `x' i.cntry dscrgrp uempla uempli married ageb ageb_sqrt gndr i.essround  , absorb(fbrncnt) cluster(cntry)
eststo: xi: areg `y' `v'  `x' i.cntry dscrgrp uempla uempli married i.rlgdnm rlgdgr ageb ageb_sqrt gndr i.essround , absorb(fbrncnt) cluster(cntry)
esttab using tables/TableD4_Panel_2.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear
restore




